/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	DrawingOpen.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CFile.h"
#include "CApplication.h"

//  Open the drawing with the specified name and return the drawing
HRESULT DrawingOpen(CString fileName,IDrawingDocument **drawing) 
{
	START_METHOD("DrawingOpen")

	HRESULT status = CONV_SUCCESS;
	IApplication *pdApplication = NULL;

	// Get the application
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	// open the drawing 
	IDrawingDocument *pDisp =  NULL;
	BSTR fName = fileName.AllocSysString();

	status = pdApplication->OpenDrawing(fName,&pDisp);
	CHECK_RETURN_STATUS(status)

	*drawing = pDisp;

	END_METHOD("DrawingOpen")
}
